﻿<?xml version = "1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- ELP_ELM_REPORT_TITLE_STRING: ^0100^ -->
<!-- Copyright @2002 Motorola Inc.  All rights reserved -->

<!-- Modification History -->
<!-- M. Sheng RADsw07288 10/21/02 Added Long Press Duration for Mobiles. -->
<picture_list>
   <list type = "common">
      <pic>^0160^</pic>
      <pic>1.jpg</pic>
      <pic>2.jpg</pic>
      <pic>3.jpg</pic>
      <pic>4.jpg</pic>
      <pic>5.jpg</pic>
      <pic>6.jpg</pic>
      <pic>handout_footer.jpg</pic>
	  <pic>spacer.jpg</pic>
   </list>
   <list type = "guppy">
      <pic>guppy9.jpg</pic>
   </list>
   <list type = "g2w">
      <pic>g2w.jpg</pic>
   </list>
   <list type = "pnk">
      <pic>pnk.jpg</pic>
      <!-- MOR PNK use the same picture, not use pnk_mor.jpg any more. CDDts06215-->
   </list>
   <list type = "plk">
      <pic>7.jpg</pic>
      <pic>8.jpg</pic>
      <pic>9.jpg</pic>
      <pic>10.jpg</pic>
      <pic>11.jpg</pic>
      <pic>plk.jpg</pic>
      <pic>CP200XLS_plk.jpg</pic>
   </list>
   <list type = "pfk">
      <pic>7.jpg</pic>
      <pic>8.jpg</pic>
      <pic>9.jpg</pic>
      <pic>10.jpg</pic>
      <pic>11.jpg</pic>
      <pic>pfk.jpg</pic>
      <pic>CP200XLS_pfk.jpg</pic>
      <pic>pfk_mor.jpg</pic>
   </list>
   <list type = "marlin">
      <pic>7.jpg</pic>
      <pic>8.jpg</pic>
      <pic>9.jpg</pic>
      <pic>marlin6.jpg</pic>
   </list>
   <list type = "mplus">
      <pic>7.jpg</pic>
      <pic>8.jpg</pic>
      <pic>9.jpg</pic>
      <pic>10.jpg</pic>
      <pic>11.jpg</pic>
      <pic>mplus.jpg</pic>
   </list>
</picture_list>

   <xsl:template match = "/">
      <xsl:text disable-output-escaping = "yes"> 
	&lt;html dir=^0034^>
&lt;meta http-equiv="Content-Type" CONTENT = "text/html; charset=utf-8"> 
      </xsl:text>
         <head>
            <title>
            ^0014^ 
            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_SERIALNUM" />
            ^0013^
            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM" />
            </title>
            <xsl:text disable-output-escaping = "yes">
               &lt;style>
                  &lt;!--
                  ul.attributes {margin-left: 0.3cm; text-align left; list-style: none; font-size: 10}
                  ul {list-style-type: none}
                  th {font-weight: bold; font-size: 10; background: #0000FF; color: "white"}
                  td {vertical-align: top; font-size: 10}
                  td.bold {vertical-align: center; font-size: 10; font-weight: bold}
                  td.pic {vertical-align: top; font-size: 10}
                  h1 {text-align: left; font-size:26; color: blue}
                  h4 {text-align: left; font-size: 10}
                  td.serialnum {text-align: left; font-size: 10}
                  td.modelnum {text-align: right; font-size: 10}
                  h3.breakBefore {page-break-before: always}
                  .std {width:640px;}
                  .gimgsize {width:300px;}
                  .lblsize {width:45px;vertical-align: top; font-size: 10}
				  .tab {width:20px}
                  -->
               &lt;/style>
            </xsl:text>
         </head>
         <body>
            <img src = "^0160^" />
            <table class = "std" >
               <tr>
                  <xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_SERIALNUM" />
                  <xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM" />
               </tr>
            </table>
            <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">
               <table class = "std" >
                  <tr>
                     <td valign = "bottom">
                        <table >
                           <tr>
                              <td class = "pic">
                                 <img src = "1.jpg" />
                              </td>
                              <td >
                                 ^0102^
                              </td>
                           </tr>                     
                           <tr>
                              <td class = "pic">
                                 <img src = "2.jpg" />
                              </td>
                              <td >
                                 ^0103^
                              </td>
                           </tr>
                           <tr>
                              <td class = "pic">
                                 <img src = "3.jpg" />
                              </td>
                              <td>
                                 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE1SHORTPRESS" mode = "portable"/>
                                 <br />
                                 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE1LONGPRESS" mode = "portable" />
                              </td>
                           </tr>
                           <tr>
                              <td class = "pic">
                                 <img src = "4.jpg" />
                              </td>
                              <td>
                                 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE2SHORTPRESS" mode = "portable"/>         
                                 <br />
                                 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE2LONGPRESS" mode = "portable"/>
                              </td>
                           </tr>

                           <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                                           contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK')">
                              <tr>
                                 <td class = "pic">
                                    <img src = "5.jpg" />
                                 </td>
                                 <td>
                                    ^0039^:
                                    <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_FRONT1SHORTPRESS"/>
                                    <br />
                                    ^0040^:
                                    <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_FRONT1LONGPRESS"/>
                                 </td>
                              </tr>
                              <tr>
                                 <td class = "pic">
                                    <img src = "6.jpg" />
                                 </td>
                                 <td>
                                    ^0041^:
                                    <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_FRONT3SHORTPRESS"/>
                                    <br />
                                    ^0042^:
                                    <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_FRONT3LONGPRESS"/>
                                 </td>
                              </tr>
                           </xsl:if>
                           <tr>
                              <td class = "pic"> 
                              </td>
                              <td>
                                 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_LONGPRESSDUR" mode = "portable"/>
                              </td>
                           </tr>                                                
                           <tr>
                             <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_SDT, '1') and 
                              			contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK'))">
                              <td class = "pic">
                                 <xsl:choose>
                                    <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                                                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK')">
                                       	    <img src = "7.jpg" />
                                    </xsl:when>
                                    <xsl:otherwise>                                    
                                       <img src = "5.jpg" />
                                    </xsl:otherwise>
                                 </xsl:choose>
                              </td>
                              <td>
                                 ^0104^
                                 <ul>
                                          <xsl:choose>
                                             <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'GUPPY') or
                                                               contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'G2W') or
                                                               contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN') or
                                                               contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK') ">
                                                   <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/PA_BLOCK/X_PA_LIST/X_CHANNAL_ALIAS" />
                                             </xsl:when>
                                             <xsl:otherwise>
                                                <li>^0133^</li>
                                             </xsl:otherwise>
                                          </xsl:choose>
                                 </ul>
                              </td>                              
                             </xsl:if>
                           </tr>
                        </table>
                     </td>
                     <td>
                        <xsl:choose>
                           <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'GUPPY')">
                              <img src = "guppy9.jpg" class = "gimgsize"/>
                           </xsl:when>
                           <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'G2W')">
                              <img src = "g2w.jpg" class = "gimgsize"/>
                           </xsl:when>
                           <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK')">
                      			<img src = "pnk.jpg" class = "gimgsize"/>
                      			<!-- MOR PNK use the same picture, not use pnk_mor.jpg any more. CDDts06215-->
                           </xsl:when>
                           <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK')">
                                <xsl:choose>
                                 <xsl:when test ="contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50JDF9AA5AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50JDH9AA6AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDF9AA5AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDH9AA6AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50QDF9AA5AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50QDH9AA6AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDF9AA5AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDH9AA6AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50SDF9AA5AN') or
											       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50SDH9AA6AN')" >
											       				     <img src = "CP200XLS_pfk.jpg" class = "gimgsize"/>
											       		</xsl:when>
                           		<xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_SDT, '1')">
                           			<img src = "pfk_mor.jpg" class = "gimgsize"/>
                           		</xsl:when>
                           		<xsl:otherwise>
                              			<img src = "pfk.jpg" class = "gimgsize"/>
                           		</xsl:otherwise>
                           	</xsl:choose>
                           </xsl:when>
                           <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK')">
                           		<xsl:choose>
									              <xsl:when test ="contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50JDF9AA5AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50JDH9AA6AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDF9AA5AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KDH9AA6AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50QDF9AA5AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50QDH9AA6AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDF9AA5AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50RDH9AA6AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50SDF9AA5AN') or
										       				     contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50SDH9AA6AN')" >
										       				     <img src = "CP200XLS_plk.jpg" class = "gimgsize"/>
										       		 </xsl:when>
										       		 <xsl:otherwise>
                                  <img src = "plk.jpg" class = "gimgsize"/>
                               </xsl:otherwise>
                              </xsl:choose>
                           </xsl:when>
                        </xsl:choose>
                     </td>
                  </tr>
               </table>
               <!-- Turn off LED if LEDs are disabled -->
               <xsl:choose>
               <xsl:when test = "ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DISALERTSEL != '^0610^' and
                                ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DISALERTSEL != '^0611^'">
               <table class = "std" >
                     <tr>
                        <td class = "lblsize">
                                 <xsl:choose>
                                    <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                                                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK')">
	                           	<xsl:choose>
	                           		<xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_SDT, '1')">
	                           			<img src = "7.jpg" />
	                           		</xsl:when>
	                           		<xsl:otherwise>
                                      			 <img src = "8.jpg" />
	                           		</xsl:otherwise>
	                           	</xsl:choose>
                                    </xsl:when>
                                    <xsl:otherwise>                                    
                                       <img src = "6.jpg" />
                                    </xsl:otherwise>
                                 </xsl:choose>
                        </td>
                        <td>
                           ^0105^ <br />
                           <table>
                              <tr>
                                 <th>
                                    ^0106^
                                 </th>
                                 <th>
                                    ^0107^
                                 </th>
                              </tr>
                              <tr>
                                 <td>
                                    ^0108^
                                 </td>
                                 <td>
                                    ^0109^
                                 </td>
                              </tr>
                              <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">
                                 <xsl:if test = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE1SHORTPRESS = '^0609^' or
                                                 ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE1LONGPRESS = '^0609^' or
                                                 ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE2SHORTPRESS = '^0609^' or
                                                 ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE2LONGPRESS = '^0609^'">
                                    <tr>
                                       <td>
                                          ^0110^
                                       </td>
                                       <td>
                                          ^0131^
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:if> 
                              <tr>
                                 <td>
                                    ^0112^
                                 </td>
                                 <td>
                                    ^0113^
                                 </td>
                              </tr>
                              <xsl:if test = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_RC_BUSYLEDEN != '0'">
                                 <tr>
                                    <td>
                                       ^0114^
                                    </td>
                                    <td>
                                       ^0115^
                                    </td>
                                 </tr>
                              </xsl:if>
                              <xsl:if test = "/ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA/ATIS_SELCALLEDEN != '0' or
			                /ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA/ATIS_CALLALERTLEDEN != '0' or
			                (   not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and
			                    (    /ELP_ELM_CODEPLUG/RRW/QC_BLOCK/ENTRY_DATA/QC_SELCALLEDEN != '0' or
			                         /ELP_ELM_CODEPLUG/RRW/DTMF_BLOCK/ENTRY_DATA/DTMF_SELCALLEDEN != '0'    )   )">
	                              	 <tr>
	                              		<td>^0116^</td>
	                                 	<td>^0117^</td>
	                                 </tr>
	                      </xsl:if>
                              <xsl:if test = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_RC_PWRUPLEDTESTEN != '0'">
                                 <tr>
                                    <td>
                                       ^0118^
                                    </td>
                                    <td>
                                       ^0119^
                                    </td>
                                 </tr>
                              </xsl:if>
                              <xsl:if test = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_RC_TXLOWBATLEDEN != '0'">
                                 <tr>
                                    <td>
                                       ^0120^
                                    </td>
                                    <td>
                                       ^0121^
                                    </td>
                                 </tr>
                              </xsl:if>
                
                              <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Portable'">
                                 <xsl:if test = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE1SHORTPRESS = '^0607^' or
                                                 ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE1LONGPRESS = '^0607^' or
                                                 ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE2SHORTPRESS = '^0607^' or
                                                 ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_SIDE2LONGPRESS = '^0607^'">
                                    <tr>
                                       <td>
                                          ^0122^
                                       </td>
                                       <td>
                                          ^0123^
                                       </td>
                                    </tr>
                                    <tr>
                                       <td>
                                          ^0124^
                                       </td>
                                       <td>
                                          ^0125^
                                       </td>
                                    </tr>
                                    <tr>
                                       <td>
                                          ^0126^
                                       </td>
                                       <td>
                                          ^0127^
                                       </td>
                                    </tr>
                                    <tr>
                                       <td>
                                          ^0128^
                                       </td>
                                       <td>
                                          ^0129^
                                       </td>
                                    </tr>
                                 </xsl:if>   
                              </xsl:if>                
                           </table>
                        </td>
                     </tr> 
                  </table>
               </xsl:when>
               <xsl:otherwise>
                  <table class = "std" >
                     <tr>
                        <td>
                           <img src = "6.jpg" />
                        </td>
                        <td> 
                           ^0132^
                        </td>
                     </tr>
                  </table>
               </xsl:otherwise>
               </xsl:choose>
            </xsl:if>  <!-- END OF PORTABLE -->
            <!-- MOBILE HANDOUT -->
            <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">
            <table class = "std" >
               <tr>
                  <td class = "pic" />
                  <td>
                     <xsl:choose>
                        <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN')">
                           <img src = "marlin6.jpg" height="200px"/>
                        </xsl:when>
                        <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
                           <img src = "mplus.jpg" height="200px"/>
                        </xsl:when>
                     </xsl:choose>
                  </td>
               </tr>
            </table>
            <table class = "std" >   
               <tr>
                  <td class = "pic">
                     <img src = "1.jpg" />
                  </td>
                  <td>
                     ^0102^
                  </td>
                  <td class = "pic">
                     <img src = "5.jpg" />
                  </td>
                  <td>
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P3SHORTPRESS" mode = "mobile"/>
                     <br />         
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P3LONGPRESS" mode = "mobile" />
                  </td>
               </tr>
               <tr>
                  <td class = "pic">
                     <img src = "2.jpg" />
                  </td>
                  <td>
                     ^0130^
                  </td>
                  <td class = "pic">
                     <img src = "6.jpg" />
                  </td>
                  <td>
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P4SHORTPRESS" mode = "mobile"/>
                     <br />         
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P4LONGPRESS" mode = "mobile" />
                  </td>
               </tr>
               <tr>
                  <td class = "pic">
                     <img src = "3.jpg" />
                  </td>
                  <td>
                     ^0104^
                     <ul>
                        <xsl:choose>
                           <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'GUPPY') or
                                             contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'G2W') or
                                             contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN') or
                                             contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK') ">
                                 <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/PA_BLOCK/X_PA_LIST/X_CHANNAL_ALIAS" />
                           </xsl:when>
                           <xsl:otherwise>
                              <li>^0133^</li>
                           </xsl:otherwise>
                        </xsl:choose>
                     </ul>
                  </td>
                  <td class = "pic">
                     <img src = "7.jpg" />
                  </td>
                  <td>
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P5SHORTPRESS" mode = "mobile"/>
                     <br />         
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P5LONGPRESS" mode = "mobile" />
                  </td>
               </tr>
               <tr>
                  <td class = "pic">
                     <img src = "4.jpg" />
                  </td>
                  <td>
                     <xsl:choose>
                     <xsl:when test = "ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DISALERTSEL != '^0610^' and
                                ELP_ELM_CODEPLUG/RRW/DR_BLOCK/ENTRY_DATA/DR_DISALERTSEL != '^0611^'">
                        ^0105^ <br />
                        <table >
                           <tr>
                              <th>
                                 ^0106^
                              </th>
                              <th>
                                 ^0107^
                              </th>
                           </tr>
                           <tr>
                              <td>
                                 ^0108^
                              </td>
                              <td>
                                 ^0109^
                              </td>
                           </tr>
                           <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">
                              <xsl:if test = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P1SHORTPRESS = '^0600^' or
                                              ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P1LONGPRESS = '^0600^' or
                                              ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P2SHORTPRESS = '^0600^' or
                                              ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P2LONGPRESS = '^0600^'">
                                 <tr>
                                    <td>
                                       ^0110^
                                    </td>
                                    <td>
                                       ^0111^
                                    </td>
                                 </tr>
                              </xsl:if>
                           </xsl:if>
                           <tr>
                              <td>
                                 ^0112^
                             </td>
                             <td>
                                ^0113^
                             </td>
                           </tr>

                           <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA" mode = "mobile_rc" />
                        
                           <xsl:if test = "ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADTYPE = 'Mobile'">
                              <xsl:if test = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P1SHORTPRESS = '^0607^' or
                                              ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P1LONGPRESS = '^0607^' or
                                              ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P2SHORTPRESS = '^0607^' or
                                              ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P2LONGPRESS = '^0607^'">
                                 <tr>
                                    <td>
                                       ^0122^
                                    </td>
                                    <td>
                                       ^0123^
                                    </td>
                                 </tr>
                                 <tr>
                                    <td>
                                       ^0124^
                                    </td>
                                    <td>
                                       ^0125^
                                    </td>
                                 </tr>
                                 <tr>
                                    <td>
                                       ^0126^
                                    </td>
                                    <td>
                                       ^0127^
                                    </td>
                                 </tr>
                                 <tr>
                                    <td>
                                       ^0128^
                                    </td>
                                    <td>
                                       ^0129^
                                    </td>
                                 </tr>
                              </xsl:if>   
                           </xsl:if>                
                        </table>
                     </xsl:when>
                     <xsl:otherwise>
                        ^0132^
                     </xsl:otherwise>
                     </xsl:choose>
                  </td>
                  <td class = "pic">
                     <img src = "8.jpg" /><br />
                     <img src = "9.jpg" />
                  </td>
                  <td>
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P1SHORTPRESS" mode = "mobile"/>
                     <br />         
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P1LONGPRESS" mode = "mobile" />
                     <br />
                     <br />
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P2SHORTPRESS" mode = "mobile"/>
                     <br />         
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P2LONGPRESS" mode = "mobile" />
                  </td>
               </tr>
               <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
                  <tr>
                     <td class = "pic" />
                     <td />
                     <td class = "pic">
                        <img src = "10.jpg" /><br />
                        <img src = "11.jpg" />
                     </td>
                     <td>
                        <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P3SHORTPRESS"/>
                        <br />         
                        <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P3LONGPRESS"/>
                        <br /> <br />
                        <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P4SHORTPRESS"/>
                        <br />         
                        <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBM_P4LONGPRESS"/>
                     </td>
                  </tr>
               </xsl:if>
               <!-- Added Long Press Duration for Mobiles.  RADsw07288 -->
               <tr>
                  <td class = "pic" />
                  <td />
                  <td class = "pic" />
                  <td>
                     <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_LONGPRESSDUR" mode = "portable"/>
                  </td>
               </tr>
            </table>
            </xsl:if>

            <img src = "handout_footer.jpg" />
            <table class = "std" >
               <tr>
                  <td>
		     <xsl:text disable-output-escaping = "yes">
                     ^0002^
		     </xsl:text>
                  </td>
                  <td align = "center">
                     <xsl:text disable-output-escaping = "yes">
                     ^0004^
                     </xsl:text>
                  </td>
                  <td align = "right">
                     <xsl:text disable-output-escaping = "yes">
                     ^0003^
                     </xsl:text>
                  </td>
               </tr>
            </table>
            
			<xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
		       <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P2SHORTPRESS, '^0155^') or
							  contains(/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/X_CBM_P2LONGPRESS, '^0155^') or
							  contains(/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_FRONT3SHORTPRESS , '^0155^') or
							  contains(/ELP_ELM_CODEPLUG/RRW/CB_BLOCK/ENTRY_DATA/CBP_FRONT3LONGPRESS, '^0155^')">
			   <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_SYSSCANTOPLEVMOPT, '^0001^') or
							  ( contains(/ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_EDITMODETOPLEVMOPT, '^0001^') and 
							      not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')) and
							      not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan')) ) or
							  /ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_AUDTONESTOPLEVMOPT = '1' or
							  contains(/ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_RPTRTATOPLEVMOPT, '^0001^') or
							  /ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_UTILSTOPLEVMOPT = '1' or
							  /ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_RADCALLTOPLEVMOPT = '1' or
							  ( contains(/ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_PHNTOPLEVMOPT, '^0001^') and
							      not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) )or
							  /ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_PGMLSTSTOPLEVMOPT = '1'">
			    
				<h3 class = "breakBefore" />
				<xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA" mode = "menu" />
                    <img src = "handout_footer.jpg" />
					<table class = "std" >
					   <tr>
						  <td>
					 <xsl:text disable-output-escaping = "yes">
							 ^0002^
					 </xsl:text>
						  </td>
						  <td align = "center">
							 <xsl:text disable-output-escaping = "yes">
							 ^0004^
							 </xsl:text>
						  </td>
						  <td align = "right">
							 <xsl:text disable-output-escaping = "yes">
							 ^0003^
							 </xsl:text>
						  </td>
					   </tr>
					</table>
				</xsl:if>
				</xsl:if>
				</xsl:if>
         </body>
      <xsl:text disable-output-escaping = "yes"> &lt;/meta> &lt;/html> </xsl:text>
   </xsl:template>

   <xsl:template match="RI_SERIALNUM">
      <td class = "serialnum">
         <xsl:value-of select="@DISPLAY_NAME" />
         <xsl:value-of select="." /> 
      </td>
   </xsl:template>

   <xsl:template match="RI_MODELNUM">
      <td class = "modelnum">
         <xsl:value-of select="@DISPLAY_NAME" />
         <xsl:value-of select="." /> 
      </td>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "mobile_rc">
      <xsl:choose>
         <xsl:when test = "RC_BUSYLEDEN != '^0000^'">
            <tr>
               <td>
			^0114^
               </td>
               <td>
                  ^0115^
               </td>
            </tr>
         </xsl:when>
      </xsl:choose>
      <xsl:if test = "/ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA/ATIS_SELCALLEDEN != '0' or
                /ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA/ATIS_CALLALERTLEDEN != '0' or
                (   not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and
                    (    /ELP_ELM_CODEPLUG/RRW/QC_BLOCK/ENTRY_DATA/QC_SELCALLEDEN != '0' or
                         /ELP_ELM_CODEPLUG/RRW/DTMF_BLOCK/ENTRY_DATA/DTMF_SELCALLEDEN != '0'    )   )">
         <tr>
                              <td>
                                 ^0116^
                              </td>
                              <td>
                                 ^0117^
                              </td>
                           </tr>
                        </xsl:if>
                        <xsl:if test = "X_RC_PWRUPLEDTESTEN != '0'">
                           <tr>
                              <td>
                                 ^0118^
                              </td>
                              <td>
                                 ^0119^
                              </td>
                           </tr>
                        </xsl:if>
   </xsl:template>

   <xsl:template match = "CBP_SIDE1SHORTPRESS" mode = "portable">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>
      
   <xsl:template match = "CBP_SIDE2SHORTPRESS" mode = "portable">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "CBP_SIDE1LONGPRESS" mode = "portable">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "CBP_SIDE2LONGPRESS" mode = "portable">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>
   
   <xsl:template match = "RC_LONGPRESSDUR" mode = "portable">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>
         
   <xsl:template match = "X_CHANNAL_ALIAS" >
         <li>
            <xsl:value-of select="position()" />
            <xsl:text disable-output-escaping = "yes">
               &amp;nbsp
            </xsl:text>
            <xsl:variable name = "oldAlias">
                   <xsl:value-of select="." />
            </xsl:variable>
            <xsl:call-template name = "aliastransform">
                <xsl:with-param name = "aliasname1">
                    <xsl:value-of select = "$oldAlias" />
                </xsl:with-param>
            </xsl:call-template>
            <xsl:if test = "position() != last()">
               <br />
            </xsl:if>
         </li>
   </xsl:template>

   <xsl:template match="ALIAS">
      <xsl:variable name = "oldAlias">
         <xsl:value-of select="." />
      </xsl:variable>
      <xsl:call-template name = "aliastransform">
         <xsl:with-param name = "aliasname1">
            <xsl:value-of select = "$oldAlias" />
         </xsl:with-param>
      </xsl:call-template>
   </xsl:template>

   <xsl:template match = "X_CBM_P1SHORTPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>
      
   <xsl:template match = "X_CBM_P2SHORTPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "X_CBM_P1LONGPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "X_CBM_P2LONGPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>
   
   <xsl:template match = "X_CBM_P3SHORTPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>
      
   <xsl:template match = "X_CBM_P4SHORTPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "X_CBM_P3LONGPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "X_CBM_P4LONGPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "X_CBM_P5LONGPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "X_CBM_P5SHORTPRESS" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "RC_LONGPRESSDUR" mode = "mobile">
      <xsl:value-of select="@DISPLAY_NAME" />:
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match = "CBM_P3SHORTPRESS">
      <xsl:value-of select = "@DISPLAY_NAME" />:
      <xsl:choose>
         <xsl:when test = ". = '0600'">
            ^0110^
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select = "." />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template match = "CBM_P3LONGPRESS">
      <xsl:value-of select = "@DISPLAY_NAME" />:
      <xsl:choose>
         <xsl:when test = ". = '0600'">
            ^0110^
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select = "." />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template match = "CBM_P4SHORTPRESS">
      <xsl:value-of select = "@DISPLAY_NAME" />:
      <xsl:choose>
         <xsl:when test = ". = '0600'">
            ^0110^
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select = "." />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template match = "CBM_P4LONGPRESS">
      <xsl:value-of select = "@DISPLAY_NAME" />:
      <xsl:choose>
         <xsl:when test = ". = '0600'">
            ^0110^
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select = "." />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "menu">
      <img src = "^0160^" />
	  <h1>^0134^</h1>
	  <table>
			<tr>
			   <td colspan = "2">
				   ^0157^
			   </td>
			</tr>
			<tr>
			   <td colspan = "2">
				   ^0158^
			   </td>
			</tr>
 		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>                       
        <xsl:if test = "contains(MN_SYSSCANTOPLEVMOPT, '^0001^')">
			<tr>
			   <td colspan = "2">
				   SYS SCAN (^0135^)
			   </td>
			</tr>
		</xsl:if>
		<xsl:if test = "MN_PGMLSTSTOPLEVMOPT = '1'">
			<tr>
				<td colspan = "2">
					PROG LST (^0142^)
				</td>
			</tr>
			<xsl:if test = "contains(MN_SCANLSTSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  SCAN LST (^0153^)
				   </td>
				</tr>				
			</xsl:if>
			<xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
							contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
				<xsl:if test = "contains(MN_PHNLSTSUBMOPT, '^0001^')and
						not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
					<tr>
						<td class = "tab" />
						<td>
							PHN LST (^0154^)
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
		</xsl:if>
        <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')) and 
        		contains(MN_PHNTOPLEVMOPT, '^0001^')">
			<tr>
			   <td colspan = "2">
				   PHONE (^0141^)
			   </td>
			</tr>
		</xsl:if>
		<xsl:if test = "MN_RADCALLTOPLEVMOPT = '1'">
			<tr>
				<td colspan = "2">
					RAD CALL (^0140^)
				</td>
			</tr>
			<xsl:if test = "contains(MN_SELCALSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  SEL CALL (^0151^)
				   </td>
				</tr>
			</xsl:if> 
			<xsl:if test = "contains(MN_CALLALERTSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  CALL ALT (^0152^)
				   </td>
				</tr>
			</xsl:if>
			 <xsl:if test ="contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan') and
	 				contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') and
	 				contains(MN_RADCHKSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					   RAD CHK (<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/MENU_BLOCK/ENTRY_DATA/MN_RADCHKSUBMOPT/@DISPLAY_NAME" />)
				   </td>
	         		</tr>
	 		</xsl:if>
		</xsl:if>     
		<xsl:if test = "MN_UTILSTOPLEVMOPT = '1'">
			<tr>
				<td colspan = "2">
					UTILITY (^0139^)
				</td>
			</tr>
			<xsl:if test = "contains(MN_SQUELCHSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  SQUELCH (^0147^)
				   </td>
				</tr>
			</xsl:if>
			<xsl:if test = "contains(MN_SELPWRLEVSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  PWR LVL (^0150^)
				   </td>
				</tr>
			</xsl:if>
			<xsl:if test = "contains(MN_OPTBOARDSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  OPT BRD (^0156^)
				   </td>
				</tr>
			</xsl:if>
			<xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') and
			                contains(MN_LIGHTDISSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  BKLT INT (^0159^)
				   </td>
				</tr>
			</xsl:if>
			<xsl:if test = "(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
			                 contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK')) and
							 contains(MN_LIGHTDISSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  LIGHT (^0149^)
				   </td>
				</tr>
			</xsl:if> 
			<xsl:if test = "contains(MN_SWVERSUBMOPT, '^0001^')">
				<tr>
				   <td class = "tab" />
				   <td>
					  SOFTWARE (^0148^)
				   </td>
				</tr>
			</xsl:if>
			
			<!-- Added by Alice Wan, CCB410 -->
			<xsl:variable name = "cpver">
				<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
			</xsl:variable>
			<xsl:variable name = "MDFRadioLockFlag">
				<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RADIOLOCK"/>
			</xsl:variable>
			<xsl:variable name ="RadioLockEnable">
				<xsl:value-of select="($cpver >= '09.00') and ($MDFRadioLockFlag = '1')"/>
			</xsl:variable>
			
			<xsl:if test ="$RadioLockEnable = 'true'">
				<xsl:if test = "contains(MN_RADLOCKSUBMOPT, '^0001^')">
					<tr>
						<td class = "tab" />
						<td>
							RAD LOC (^3267^)
						</td>
					</tr>
				</xsl:if>
			</xsl:if>	
			<!-- Added by Alice Wan, CCB410 -->
			
			<!-- Added by Xiao Yuek for CCB393 -->		
			<xsl:variable name = "cpver">
				<xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
			</xsl:variable>

			<xsl:variable name = "MDFRussianFlag">
				<xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_RUSSIAN_EN"/>
			</xsl:variable>

			<xsl:variable name ="RegionID">
				<xsl:value-of select="/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID"/>
			</xsl:variable>			

			<xsl:variable name ="RussianEnable">
				<xsl:value-of select="($cpver >= '08.00') and ($RegionID = 'EMEA') and ($MDFRussianFlag = '1')"/>
			</xsl:variable>

			<xsl:if test ="$RussianEnable = 'true'">
				<xsl:if test = "contains(MN_LANGMODESUBMOPT, '^0001^')">
					<tr>
						<td class = "tab" />
						<td>
							LANGUAGE (^3266^)
						</td>
					</tr>
				</xsl:if>
			</xsl:if>
			<!-- End for CCB393 -->
		</xsl:if>
		<xsl:if test = "contains(MN_RPTRTATOPLEVMOPT, '^0001^')">
			<tr>
			   <td colspan = "2">
				   TALKARND (^0138^)
			   </td>
			</tr>
		</xsl:if>
		<xsl:if test = "MN_AUDTONESTOPLEVMOPT = '1'">
			<tr>
				<td colspan = "2">
					TONES (^0137^)
				</td>
			</tr>
			<xsl:if test = "contains(MN_TONEDISASUBMOPT, '^0001^')">
				<tr>
					<td class = "tab" />
					<td>
					   TONE (^0143^)
					</td>
				 </tr>
			 </xsl:if>

			 <xsl:if test = "contains(MN_CALLTONETAGSUBMOPT, '^0001^')">
				 <tr>
					<td class = "tab" />
					<td>
					   TONE TAG (^0146^)
					</td>
				 </tr>
			 </xsl:if>
			 <xsl:if test = "contains(MN_ESCALERTSUBMOPT, '^0001^')">          
				<tr>
				   <td class = "tab" />
				   <td>
					  ESCALERT (^0145^)
				   </td>
				</tr>
			 </xsl:if>
			 <xsl:if test = "contains(MN_KEYPADTONESSUBMOPT, '^0001^')">
				 <tr>
					<td class = "tab" />
					<td>
					   KPD TONE (^0144^)
					</td>
				 </tr>
			 </xsl:if>
		</xsl:if>
        <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA'))">
			<xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan')) and 
					contains(MN_EDITMODETOPLEVMOPT, '^0001^')">
				<tr>
				   <td colspan = "2">
					   EDIT PL (^0136^)
				   </td>
				</tr>
			</xsl:if>
		</xsl:if>
	  </table>
	  <table>
	  <xsl:if test = " not(contains(MN_SYSSCANTOPLEVMOPT, '^0001^')) ">
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </xsl:if>
	  <xsl:if test = " not(MN_PGMLSTSTOPLEVMOPT = '1')">
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </xsl:if>
	  <xsl:if test = " not(contains(MN_PHNTOPLEVMOPT, '^0001^')) or
	  		   contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani')">
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </xsl:if>
	  <xsl:if test = " not(MN_RADCALLTOPLEVMOPT = '1')">
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </xsl:if>
	  <xsl:if test = " not(MN_UTILSTOPLEVMOPT = '1')">
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </xsl:if>
	  <xsl:if test = " not(contains(MN_RPTRTATOPLEVMOPT, '^0001^'))">
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </xsl:if>
	  <xsl:if test = " not(MN_AUDTONESTOPLEVMOPT = '1')">
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </xsl:if>	  
	  	  	    
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	     <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	     <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
		 <tr>
		    <td><img src = "spacer.jpg" /></td>
		 </tr>
	  </table>
   </xsl:template>
   
   <xsl:template name="aliastransform">
      <xsl:param name="aliasname1"></xsl:param>
         <xsl:variable name = "x1">
            <xsl:value-of select="translate($aliasname1, '(', '&amp;')"/>      
         </xsl:variable>
         <xsl:value-of select = "translate($x1, ')?!$%', 'nbsp;')" />
   </xsl:template>

</xsl:stylesheet>